function showSimilarNeurons(obj,neuron,N)
%SHOWSIMILARNEURONS Show the other neurons which are most similar to
%'neuron'
%   N - optional parameter to specify how many results to show

if nargin < 3
    N = 10;
end

data = obj.S(strcmp(obj.Slabels,neuron),:);

[sortedData idxs] = sort(data,'descend');

fprintf('Neuron\t\tSimilarity\n');
for i = 1:(min(N,numel(sortedData)))
    fprintf('%6s\t\t%.4f\n',obj.Slabels{idxs(i)},full(sortedData(i)));
end

end

